// PageSettingAlarm.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageSettingAlarm.h"
#include "Include\CommonFun.h"
#include "Include\CLS_NVDSDK_Interface.h"
#include "NvsInfo.h"

// 128Ƶʧ129˿ڱ130ƶ⣻131134Ԥ135ض˿ڱ136Դ
#define ALARM_TYPE_VIDEO_LOST	128 + 0
#define ALARM_TYPE_NET_PORT		128 + 1
#define ALARM_TYPE_MOVE_DETECT	128 + 2
#define ALARM_TYPE_LOCAL_PORT	128 + 7
#define ALARM_TYPE_POWER		128 + 8

// CPageSettingAlarm dialog

IMPLEMENT_DYNAMIC(CPageSettingAlarm, CDialog)

CPageSettingAlarm::CPageSettingAlarm(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CPageSettingAlarm::IDD, pParent)
{
	memset(&m_CurSchParam, 0, sizeof(m_CurSchParam));
	m_CurSchParam.iBuffSize = sizeof(AlarmScheduleParam);
	m_CurSchParam.iAlarmType = MAX_SHEDLE_ALARM_TYPE;
}

CPageSettingAlarm::~CPageSettingAlarm()
{
}

void CPageSettingAlarm::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CBO_ALARM_INPUT_PORT, m_cboAlarmInputPort);
	DDX_Control(pDX, IDC_CBO_ALARM_INPUT_MODE_SET, m_cboAlarmInputModeSet);
	DDX_Control(pDX, IDC_CBO_ALARM_OUTPUT_PORT, m_cboAlarmOutputPort);
	DDX_Control(pDX, IDC_CBO_ALARM_OUTPUT_MODE_SET, m_cboAlarmOutputModeSet);
	DDX_Control(pDX, IDC_CBO_ALARM_OUTPUT_TIME_LATE, m_cboAlarmOutputTimeLate);
	DDX_Control(pDX, IDC_CBO_ALARM_WEEKDAY_WEEK, m_cboAlarmWeekdayWeek);
	DDX_Control(pDX, IDC_DT_ALARM_WEEKDAY_BEGIN_TIME, m_dtAlarmWeekdayBeginTime);
	DDX_Control(pDX, IDC_DT_ALARM_WEEKDAY_END_TIME, m_dtAlarmWeekdayEndTime);
	DDX_Control(pDX, IDC_CBO_ALARM_ALARM_TYPE, m_cboAlarmAlarmType);
	DDX_Control(pDX, IDC_CHK_ALARM_ALARM_ENABLE, m_chkAlarmAlarmEnable);
	DDX_Control(pDX, IDC_CBO_ALARM_ALARM_INPUT_PORT, m_cboAlarmAlarmInputPort);
}


BEGIN_MESSAGE_MAP(CPageSettingAlarm, CDialog)
	ON_BN_CLICKED(IDC_BTN_ALARM_INPUT_SET, &CPageSettingAlarm::OnBnClickedBtnAlarmInputSet)
	ON_BN_CLICKED(IDC_BTN_ALARM_OUTPUT_SET, &CPageSettingAlarm::OnBnClickedBtnAlarmOutputSet)
	ON_BN_CLICKED(IDC_BTN_ALARM_WEEKDAY_SET, &CPageSettingAlarm::OnBnClickedBtnAlarmWeekdaySet)
	ON_BN_CLICKED(IDC_BTN_ALARM_ALARM_LINK, &CPageSettingAlarm::OnBnClickedBtnAlarmAlarmLink)
	ON_BN_CLICKED(IDC_BTN_ALARM_ALARM_SET, &CPageSettingAlarm::OnBnClickedBtnAlarmAlarmSet)
	ON_CBN_SELCHANGE(IDC_CBO_ALARM_INPUT_PORT, &CPageSettingAlarm::OnCbnSelchangeCboAlarmInputPort)
	ON_CBN_SELCHANGE(IDC_CBO_ALARM_OUTPUT_PORT, &CPageSettingAlarm::OnCbnSelchangeCboAlarmOutputPort)
	ON_CBN_SELCHANGE(IDC_CBO_ALARM_WEEKDAY_WEEK, &CPageSettingAlarm::OnCbnSelchangeCboAlarmWeekdayWeek)
	ON_CBN_SELCHANGE(IDC_CBO_ALARM_ALARM_INPUT_PORT, &CPageSettingAlarm::OnCbnSelchangeCboAlarmAlarmInputPort)
	ON_CBN_SELCHANGE(IDC_CBO_ALARM_ALARM_TYPE, &CPageSettingAlarm::OnCbnSelchangeCboAlarmAlarmType)
	ON_BN_CLICKED(IDC_BUTTON_ALARM_LINK_SWITCH_DISENBALE, &CPageSettingAlarm::OnBnClickedButtonAlarmLinkSwitchDisenbale)
END_MESSAGE_MAP()


// CPageSettingAlarm message handlers

void  CPageSettingAlarm::LoadSurfaceResource()
{
	SetDlgItemText(IDC_STC_ALARM_ALARM_INPUT, GetText(IDS_ALARM_ALARM_INPUT));
	SetDlgItemText(IDC_STC_ALARM_ALARM_OUTPUT, GetText(IDS_ALARM_ALARM_OUTPUT));
	SetDlgItemText(IDC_STC_ALARM_WEEKDAY, GetText(IDS_ALARM_WEEKDAY));
	SetDlgItemText(IDC_STC_ALARM_INPUT_PORT, GetText(IDS_ALARM_INPUT_PORT));
	SetDlgItemText(IDC_STC_ALARM_INPUT_MODE_SET, GetText(IDS_ALARM_INPUT_MODE_SET));
	SetDlgItemText(IDC_STC_ALARM_OUTPUT_PORT, GetText(IDS_ALARM_OUTPUT_PORT));
	SetDlgItemText(IDC_STC_ALARM_OUTPUT_MODE_SET, GetText(IDS_ALARM_OUTPUT_MODE_SET));
	SetDlgItemText(IDC_STC_ALARM_ALARM_SET, GetText(IDS_ALARM_ALARM_SET));
	SetDlgItemText(IDC_STC_ALARM_WEEKDAY_WEEK, GetText(IDS_ALARM_WEEKDAY_WEEK));
	SetDlgItemText(IDC_STC_ALARM_OUTPUT_TIME_LATE, GetText(IDS_ALARM_OUTPUT_TIME_LATE));
	SetDlgItemText(IDC_STC_ALARM_WEEKDAY_BEGIN_TIME, GetText(IDS_ALARM_WEEKDAY_BEGIN_TIME));
	SetDlgItemText(IDC_STC_ALARM_WEEKDAY_END_TIME, GetText(IDS_ALARM_WEEKDAY_END_TIME));
	SetDlgItemText(IDC_STC_ALARM_ALARM_TYPE, GetText(IDS_ALARM_ALARM_TYPE));
	SetDlgItemText(IDC_STC_ALARM_ALARM_INPUT_PORT, GetText(IDS_ALARM_ALARM_INPUT_PORT));
	SetDlgItemText(IDC_STC_ALARM_ALARM_LINK_OUTPUT, GetText(IDS_ALARM_ALARM_LINK_OUTPUT));
	SetDlgItemText(IDC_BTN_ALARM_INPUT_SET, GetText(IDS_SETTING_SET));
	SetDlgItemText(IDC_BTN_ALARM_OUTPUT_SET, GetText(IDS_SETTING_SET));
	SetDlgItemText(IDC_BTN_ALARM_WEEKDAY_SET, GetText(IDS_SETTING_SET));
	SetDlgItemText(IDC_BTN_ALARM_ALARM_LINK, GetText(IDS_ALARM_LINK_CHANGE));
	SetDlgItemText(IDC_BTN_ALARM_ALARM_SET, GetText(IDS_SETTING_SET));
	SetDlgItemText(IDC_BUTTON_ALARM_LINK_SWITCH_DISENBALE, GetText(IDS_MAIN_STOPAUTOSWITCH));
}

int CPageSettingAlarm::Initialize(TDECPARAM* _pdecParam)
{
	m_iCurChanlNum = _pdecParam->m_iChannel;
	LoadSurfaceResource();
	CString cstrTemp;
	for (int i = 0; i < MAX_ALARM_INPUT_NUM; i++)
	{
		cstrTemp.Format(_T("%d"), i + 1);
		m_cboAlarmInputPort.AddString(cstrTemp);
		m_cboAlarmAlarmInputPort.AddString(cstrTemp);
	}

	for (int i = 0; i < MAX_ALARM_OUTPUT_NUM; i++)
	{
		cstrTemp.Format(_T("%d"), i + 1);
		m_cboAlarmOutputPort.AddString(cstrTemp);
	}

	m_cboAlarmInputModeSet.AddString(GetText(IDS_ALARM_OFF));
	m_cboAlarmInputModeSet.AddString(GetText(IDS_ALARM_ON));
	
	m_cboAlarmOutputModeSet.AddString(GetText(IDS_ALARM_OFF));
	m_cboAlarmOutputModeSet.AddString(GetText(IDS_ALARM_ON));

	int iIndex = m_cboAlarmOutputTimeLate.AddString(GetText(IDS_ALARM_NOT_DELAY));
	m_cboAlarmOutputTimeLate.SetItemData(iIndex,0);
	iIndex = m_cboAlarmOutputTimeLate.AddString(_T("1"));
	m_cboAlarmOutputTimeLate.SetItemData(iIndex,1);
	iIndex = m_cboAlarmOutputTimeLate.AddString(_T("2"));
	m_cboAlarmOutputTimeLate.SetItemData(iIndex,2);
	iIndex = m_cboAlarmOutputTimeLate.AddString(_T("5"));
	m_cboAlarmOutputTimeLate.SetItemData(iIndex,5);
	iIndex = m_cboAlarmOutputTimeLate.AddString(_T("10"));
	m_cboAlarmOutputTimeLate.SetItemData(iIndex,10);
	iIndex = m_cboAlarmOutputTimeLate.AddString(_T("30"));
	m_cboAlarmOutputTimeLate.SetItemData(iIndex,30);

	m_cboAlarmWeekdayWeek.AddString(GetText(IDS_ALARM_SUNDAY));
	m_cboAlarmWeekdayWeek.AddString(GetText(IDS_ALARM_MONDAY));
	m_cboAlarmWeekdayWeek.AddString(GetText(IDS_ALARM_TUESDAY));
	m_cboAlarmWeekdayWeek.AddString(GetText(IDS_ALARM_WENDESDAY));
	m_cboAlarmWeekdayWeek.AddString(GetText(IDS_ALARM_THURSDAY));
	m_cboAlarmWeekdayWeek.AddString(GetText(IDS_ALARM_FRIDAY));
	m_cboAlarmWeekdayWeek.AddString(GetText(IDS_ALARM_SATURDAY));

	iIndex = m_cboAlarmAlarmType.AddString(GetText(IDS_ALARM_LOCAL_PORT_ALARM));
	m_cboAlarmAlarmType.SetItemData(iIndex, ALARM_TYPE_LOCAL_PORT);
	iIndex = m_cboAlarmAlarmType.AddString(GetText(IDS_ALARM_VIDEO_LOST));
	m_cboAlarmAlarmType.SetItemData(iIndex, ALARM_TYPE_VIDEO_LOST);
	iIndex = m_cboAlarmAlarmType.AddString(GetText(IDS_ALARM_PORT_ALARM));
	m_cboAlarmAlarmType.SetItemData(iIndex, ALARM_TYPE_NET_PORT);
	iIndex = m_cboAlarmAlarmType.AddString(GetText(IDS_ALARM_MOVE_DETECTION));
	m_cboAlarmAlarmType.SetItemData(iIndex, ALARM_TYPE_MOVE_DETECT);
	iIndex = m_cboAlarmAlarmType.AddString(GetText(IDS_ALARM_POWER));
	m_cboAlarmAlarmType.SetItemData(iIndex, ALARM_TYPE_POWER);
	//add begin ʱʼͱ
	GetAlarmInput(0);
	GetAlarmOutput(0);
	//add end
	initShedule_Set();
    return 0;
}

int CPageSettingAlarm::GetAlarmInput(int _iAlarmPort)
{
	//ʼ
	AlarmInAndOut structAlarmInAndOut = {0};
	structAlarmInAndOut.iBuffSize = sizeof(AlarmInAndOut);
	structAlarmInAndOut.iType = enAlarmInputMode;
	structAlarmInAndOut.iPortNo = _iAlarmPort;
	m_cboAlarmInputPort.SetCurSel(_iAlarmPort);
	if(NULL != DEC_ClientGetDevConfig)
	{
		int iRet = DEC_ClientGetDevConfig(m_lLogonID,0,0,CMD_DEC_CFG_ALARM_IN_OUT,&structAlarmInAndOut,sizeof(AlarmInAndOut));
		if (iRet == 0)
		{

			m_cboAlarmInputModeSet.SetCurSel(structAlarmInAndOut.iPara1);
		}
		else
		{
			AddLog(LOG_LEVEL_DEBUG,"[CPageSettingAlarm::GetAlarmInput] DEC_ClientGetDevConfig failed!cmd(%d),structAlarmInAndOut.iPortNo(%d), error(%d)"
				,CMD_DEC_CFG_ALARM_IN_OUT,structAlarmInAndOut.iPortNo,GetLastError());
		}
	}
	
	return 0;
}

int CPageSettingAlarm::GetAlarmOutput(int _iAlarmPort)
{
	//ʼ
	AlarmInAndOut structAlarmInAndOut = {0};
	structAlarmInAndOut.iBuffSize = sizeof(AlarmInAndOut);
	structAlarmInAndOut.iType = enAlarmOuputMode;
	structAlarmInAndOut.iPortNo = _iAlarmPort;
	m_cboAlarmOutputPort.SetCurSel(_iAlarmPort);
	if(NULL != DEC_ClientGetDevConfig)
	{
		int iRet = DEC_ClientGetDevConfig(m_lLogonID,0,0,CMD_DEC_CFG_ALARM_IN_OUT,&structAlarmInAndOut,sizeof(AlarmInAndOut));
		if (iRet == 0)
		{
			m_cboAlarmOutputModeSet.SetCurSel(structAlarmInAndOut.iPara1);
			for (int i = 0; i < m_cboAlarmOutputTimeLate.GetCount(); ++i)
			{
				if (structAlarmInAndOut.iPara2 == m_cboAlarmOutputTimeLate.GetItemData(i))
				{
					m_cboAlarmOutputTimeLate.SetCurSel(i);
				}
			}			
		}
		else
		{
			AddLog(LOG_LEVEL_DEBUG,"[CPageSettingAlarm::GetAlarmOutput] DEC_ClientGetDevConfig failed!cmd(%d),structAlarmInAndOut.iPortNo(%d), error(%d)"
				,CMD_DEC_CFG_ALARM_IN_OUT,structAlarmInAndOut.iPortNo,GetLastError());
		}
	}
	return 0;
}

BOOL CPageSettingAlarm::PreTranslateMessage(MSG* pMsg)
{
	if(pMsg->message == WM_KEYDOWN && (pMsg->wParam == VK_RETURN||pMsg->wParam == VK_ESCAPE)) 
	{ 
		return true;
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CPageSettingAlarm::OnBnClickedBtnAlarmInputSet()
{
	// TODO: Add your control notification handler code here
	AlarmInAndOut structAlarmInAndOut = {0};

	structAlarmInAndOut.iBuffSize = sizeof(AlarmInAndOut);
	structAlarmInAndOut.iType = enAlarmInputMode;
	structAlarmInAndOut.iPortNo = m_cboAlarmInputPort.GetCurSel();

	structAlarmInAndOut.iPara1 = m_cboAlarmInputModeSet.GetCurSel();

	if(NULL != DEC_ClientSetDevConfig)
	{
		int iRet = DEC_ClientSetDevConfig(m_lLogonID,0,0,CMD_DEC_CFG_ALARM_IN_OUT,&structAlarmInAndOut,sizeof(AlarmInAndOut));
		if (iRet == 0)
		{
		}
		else
		{
			AddLog(LOG_LEVEL_DEBUG,"[CPageSettingAlarm::OnBnClickedBtnAlarmInputSet] DEC_ClientSetDevConfig failed!cmd(%d),structAlarmInAndOut.iPortNo(%d), error(%d)"
				,CMD_DEC_CFG_ALARM_IN_OUT,structAlarmInAndOut.iPortNo,GetLastError());
		}
	}
}

void CPageSettingAlarm::OnBnClickedBtnAlarmOutputSet()
{
	// TODO: Add your control notification handler code here
	AlarmInAndOut structAlarmInAndOut = {0};

	structAlarmInAndOut.iBuffSize = sizeof(AlarmInAndOut);
	structAlarmInAndOut.iType = enAlarmOuputMode;
	structAlarmInAndOut.iPortNo = m_cboAlarmOutputPort.GetCurSel();

	structAlarmInAndOut.iPara1 = m_cboAlarmOutputModeSet.GetCurSel();

	int iIndex = m_cboAlarmOutputTimeLate.GetCurSel();
	structAlarmInAndOut.iPara2 = m_cboAlarmOutputTimeLate.GetItemData(iIndex);

	if(NULL != DEC_ClientSetDevConfig)
	{
		int iRet = DEC_ClientSetDevConfig(m_lLogonID,0,0,CMD_DEC_CFG_ALARM_IN_OUT,&structAlarmInAndOut,sizeof(AlarmInAndOut));
		if (iRet == 0)
		{
		}
		else
		{
			AddLog(LOG_LEVEL_DEBUG,"[CPageSettingAlarm::OnBnClickedBtnAlarmOutputSet] DEC_ClientSetDevConfig failed!cmd(%d),structAlarmInAndOut.iPortNo(%d), error(%d)"
				,CMD_DEC_CFG_ALARM_IN_OUT,structAlarmInAndOut.iPortNo,GetLastError());
		}
	}
}

void CPageSettingAlarm::OnBnClickedBtnAlarmWeekdaySet()
{//κʹһùȥ~
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_ALARM_SCHEDULE, &m_CurSchParam, sizeof(AlarmScheduleParam));
	if (iRet >= 0)
	{
		//sucess
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingAlarm::Initialize] DEC_ClientGetDevConfig Failed! cmd(%d),error(%d)",CMD_DEC_CFG_ALARM_SCHEDULE,GetLastError());
	}

	int iWeek = m_cboAlarmWeekdayWeek.GetCurSel();
	CTime timeStart;
	CTime timeStop;
	m_dtAlarmWeekdayBeginTime.GetTime(timeStart);
	m_dtAlarmWeekdayEndTime.GetTime(timeStop);
	if (timeStart > timeStop)
	{
		//AfxMessageBox(GetText(IDS_MSG_ALARM_TIME));
		MessageBox(GetText(IDS_MSG_ALARM_TIME), GetText(IDS_SETTING_ALARMTITLE), MB_OK|MB_TOPMOST);
		return;
	}
	DEC_SCHEDTIME schedtime;	
	schedtime.iStartHour = timeStart.GetHour();
	schedtime.iStartMin = timeStart.GetMinute();
	schedtime.iStopHour = timeStop.GetHour();
	schedtime.iStopMin = timeStop.GetMinute();
	if (timeStart == timeStop)
	{
		schedtime.iEnable = 0;//òʹܷ
	}
	else
	{
		schedtime.iEnable = 1;
	}
	m_CurSchParam.timeSeg[iWeek][0] = schedtime;

	m_CurSchParam.iBuffSize = sizeof(AlarmScheduleParam);
	m_CurSchParam.iAlarmType = MAX_SHEDLE_ALARM_TYPE;
	m_CurSchParam.iWeekday = iWeek;
	iRet = DEC_ClientSetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_ALARM_SCHEDULE, &m_CurSchParam, sizeof(AlarmScheduleParam));
	if (iRet >= 0)
	{
		//success
	} 
	else
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingAlarm::OnBnClickedBtnAlarmWeekdaySet] DEC_ClientSetDevConfig Failed! cmd(%d),error(%d)",CMD_DEC_CFG_ALARM_SCHEDULE,GetLastError());
	}
}

void CPageSettingAlarm::OnBnClickedBtnAlarmAlarmLink()
{
	// TODO: Add your control notification handler code here
	//TNVSITEMEX tNvsItemEx = {0};
	//tNvsItemEx.m_iStructLen = sizeof(TNVSITEMEX);

	//tNvsItemEx.m_stOldItem.m_serNetmode = 1;
	//tNvsItemEx.m_stOldItem.m_serPort = 3000;
	//tNvsItemEx.m_stOldItem.m_iAddress = 1;
	//tNvsItemEx.m_stOldItem.m_holdtime = 20;
	//strcpy_s(tNvsItemEx.m_stOldItem.m_username,sizeof(tNvsItemEx.m_stOldItem.m_username),"Admin");
	//strcpy_s(tNvsItemEx.m_stOldItem.m_password,sizeof(tNvsItemEx.m_stOldItem.m_password),"1111");

	ViewServerInfo tViewServer = {0};
	tViewServer.ser_net_mode = 1;
	tViewServer.ser_port = 3000;
	tViewServer.ser_ptz_addr = 1;
	tViewServer.hold_time = 20;
	strcpy_s(tViewServer.ser_usr_name, sizeof(tViewServer.ser_usr_name), "Admin");
	strcpy_s(tViewServer.ser_usr_pwd, sizeof(tViewServer.ser_usr_pwd), "1111");

	CNvsInfo dlgNvsInfo;
	int iModify = DLG_STYLE_SET; 
	dlgNvsInfo.InitEx(-1, &tViewServer, iModify, m_lLogonID);
	dlgNvsInfo.SetAlarmType(GetAlarmType(m_cboAlarmAlarmType.GetCurSel()), m_cboAlarmAlarmInputPort.GetCurSel());
	if(dlgNvsInfo.DoModal() == IDOK)
	{
	}
}

void CPageSettingAlarm::OnBnClickedBtnAlarmAlarmSet()
{
	ScheduleEnable enablePara = {0};
	int iType = GetAlarmType(m_cboAlarmAlarmType.GetCurSel());
	enablePara.iBuffSize = sizeof(ScheduleEnable);
	if (m_cboAlarmAlarmType.GetCurSel() == 0)
	{
		enablePara.iChannelNo = m_cboAlarmAlarmInputPort.GetCurSel();
	}
	else
	{
		enablePara.iChannelNo = 0;
	}
	enablePara.iEnable = m_chkAlarmAlarmEnable.GetCheck();
	enablePara.iAlarmType = iType;

	int iRet = DEC_ClientSetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_SCHEDULE_ENABLE, &enablePara, sizeof(ScheduleEnable));
	if (iRet >= 0)
	{
		//ö˿
		AlarmLink alarmParm = {0};
		alarmParm.iBuffSize = sizeof(AlarmLink);
		alarmParm.iAlarmType = iType;
		alarmParm.iChannelNo = m_cboAlarmAlarmInputPort.GetCurSel();
		alarmParm.iLinkType = 2;
		int iEnable = 0;
		for (int j=0; j<MAX_ALARM_LINK_NUM; j++)
		{
			if (((CButton*)GetDlgItem(j+IDC_CHK_ALARM_LINK_OUTPUT_NO1))->GetCheck())
			{
				iEnable |= 1<<j;
			}					
		}
		alarmParm.iLinkParam1 = iEnable;
		int iRet = DEC_ClientSetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_ALARM_LINK,&alarmParm, sizeof(AlarmLink));
		if (iRet >= 0)
		{
			//sucess
		} 
		else
		{
			AddLog(LOG_LEVEL_ERROR,"[CPageSettingAlarm::OnBnClickedBtnAlarmAlarmSet] DEC_ClientSetDevConfig Failed! cmd(%d),error(%d)",CMD_DEC_CFG_ALARM_LINK,GetLastError());
		}

	}
	else
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingAlarm::OnBnClickedBtnAlarmAlarmSet] DEC_ClientSetDevConfig Failed! cmd(%d),error(%d)",CMD_DEC_CFG_SCHEDULE_ENABLE,GetLastError());
	}
}

void CPageSettingAlarm::OnCbnSelchangeCboAlarmWeekdayWeek()
{
	int iIndex = m_cboAlarmWeekdayWeek.GetCurSel();
	if (iIndex < 0)
	{
		return;
	}
	m_CurSchParam.iWeekday = iIndex;
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_ALARM_SCHEDULE, &m_CurSchParam, sizeof(AlarmScheduleParam));
	if (iRet >= 0)
	{
		DEC_SCHEDTIME *pTS = NULL;
		CTime timeNow = CTime::GetCurrentTime();
		CTime timeSchStart, timeSchStop;
		pTS = &m_CurSchParam.timeSeg[iIndex][0];
		VERIFY(pTS);
		timeSchStart = CTime(timeNow.GetYear(), timeNow.GetMonth(), timeNow.GetDay(),pTS->iStartHour, pTS->iStartMin, 0);
		timeSchStop = CTime(timeNow.GetYear(), timeNow.GetMonth(), timeNow.GetDay(),pTS->iStopHour, pTS->iStopMin, 0);
		m_dtAlarmWeekdayBeginTime.SetTime(&timeSchStart);
		m_dtAlarmWeekdayEndTime.SetTime(&timeSchStop);		
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingAlarm::Initialize] DEC_ClientGetDevConfig Failed! cmd(%d),error(%d)",CMD_DEC_CFG_ALARM_SCHEDULE,GetLastError());
	}
}

void CPageSettingAlarm::OnCbnSelchangeCboAlarmInputPort()
{
	int iIndex = m_cboAlarmInputPort.GetCurSel();
	GetAlarmInput(iIndex);
}

void CPageSettingAlarm::OnCbnSelchangeCboAlarmOutputPort()
{	
	int iIndex = m_cboAlarmOutputPort.GetCurSel();
	GetAlarmOutput(iIndex);
}

int CPageSettingAlarm::initShedule_Set()
{
	//ʼ
	m_cboAlarmWeekdayWeek.SetCurSel(0);
	m_CurSchParam.iWeekday = m_cboAlarmWeekdayWeek.GetCurSel();
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_ALARM_SCHEDULE, &m_CurSchParam, sizeof(AlarmScheduleParam));
	if (iRet >= 0)
	{
		DEC_SCHEDTIME *pTS = NULL;
		CTime timeNow = CTime::GetCurrentTime();
		CTime timeSchStart, timeSchStop;
		pTS = &m_CurSchParam.timeSeg[0][0];
		VERIFY(pTS);
		timeSchStart = CTime(timeNow.GetYear(), timeNow.GetMonth(), timeNow.GetDay(),pTS->iStartHour, pTS->iStartMin, 0);
		timeSchStop = CTime(timeNow.GetYear(), timeNow.GetMonth(), timeNow.GetDay(),pTS->iStopHour, pTS->iStopMin, 0);
		m_dtAlarmWeekdayBeginTime.SetTime(&timeSchStart);
		m_dtAlarmWeekdayEndTime.SetTime(&timeSchStop);		
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingAlarm::Initialize] DEC_ClientGetDevConfig Failed! cmd(%d),error(%d)",CMD_DEC_CFG_ALARM_SCHEDULE,GetLastError());
	}
	
	m_cboAlarmAlarmType.SetCurSel(0);
	m_cboAlarmAlarmInputPort.SetCurSel(0);
	//ʼʹ״̬
	GetAlarmEnable();
	//ʼ˿
	AlarmLink alarmParm = {0};
	alarmParm.iBuffSize = sizeof(AlarmLink);
	alarmParm.iChannelNo = m_cboAlarmAlarmInputPort.GetCurSel();
	alarmParm.iLinkType = 2;
	alarmParm.iAlarmType = GetAlarmType(m_cboAlarmAlarmType.GetCurSel());
	iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_ALARM_LINK,&alarmParm, sizeof(AlarmLink));
	if (iRet >= 0)
	{
		//ʼ˿ 
		int iEnable = alarmParm.iLinkParam1;
		for (int j=0; j<MAX_ALARM_LINK_NUM; j++)
		{
			if (iEnable >> j & 1)
			{
				((CButton*)GetDlgItem(j+IDC_CHK_ALARM_LINK_OUTPUT_NO1))->SetCheck(true);
			}					
		}
	} 
	else
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingAlarm::initShedule_Set] DEC_ClientGetDevConfig Failed! cmd(%d),error(%d)",CMD_DEC_CFG_ALARM_LINK,GetLastError());
		return -1;
	}
	return 0;
}

int CPageSettingAlarm::GetAlarmType(int _iSeriNo, bool blFlag)
{
	int iType = m_cboAlarmAlarmType.GetItemData(_iSeriNo);
	return iType;
}

void CPageSettingAlarm::OnCbnSelchangeCboAlarmAlarmInputPort()
{
	GetAlarmEnable();
	initOutPort();//ʼ˿
}

void CPageSettingAlarm::OnCbnSelchangeCboAlarmAlarmType()
{
	if (m_cboAlarmAlarmType.GetCurSel() == 0)
	{
		m_cboAlarmAlarmInputPort.EnableWindow(TRUE);
		GetDlgItem(IDC_BTN_ALARM_ALARM_LINK)->EnableWindow(TRUE);
	} 
	else
	{
		m_cboAlarmAlarmInputPort.EnableWindow(false);
		GetDlgItem(IDC_BTN_ALARM_ALARM_LINK)->EnableWindow(FALSE);
	}
	GetAlarmEnable();
	initOutPort();//ʼ˿
}


void CPageSettingAlarm::GetAlarmEnable()
{
	//ȡʹ״̬
	ScheduleEnable enablePara = {0};
	int iType = GetAlarmType(m_cboAlarmAlarmType.GetCurSel());
	enablePara.iBuffSize = sizeof(ScheduleEnable);
	if (m_cboAlarmAlarmType.GetCurSel() == 0)
	{
		enablePara.iChannelNo = m_cboAlarmAlarmInputPort.GetCurSel();
	}
	else
	{
		enablePara.iChannelNo = 0;
	}
	enablePara.iAlarmType = iType;
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0,CMD_DEC_CFG_SCHEDULE_ENABLE, &enablePara, sizeof(ScheduleEnable));
	if(iRet >= 0)
	{
		m_chkAlarmAlarmEnable.SetCheck(enablePara.iEnable);
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingAlarm::GetAlarmEnable] DEC_ClientGetDevConfig Failed! cmd(%d),error(%d)",CMD_DEC_CFG_SCHEDULE_ENABLE,GetLastError());
	}
}


void CPageSettingAlarm::initOutPort()
{
	AlarmLink alarmParm = {0};
	alarmParm.iBuffSize = sizeof(AlarmLink);
	alarmParm.iChannelNo = m_cboAlarmAlarmInputPort.GetCurSel();
	alarmParm.iLinkType = 2;
	alarmParm.iAlarmType = GetAlarmType(m_cboAlarmAlarmType.GetCurSel());
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_ALARM_LINK,&alarmParm, sizeof(AlarmLink));
	if (iRet >= 0)
	{
		//ʼ˿ 
		int iEnable = alarmParm.iLinkParam1;
		for (int j=0; j<MAX_ALARM_LINK_NUM; j++)
		{
			if (iEnable >> j & 1)
			{
				((CButton*)GetDlgItem(j+IDC_CHK_ALARM_LINK_OUTPUT_NO1))->SetCheck(true);
			}
			else
			{
				((CButton*)GetDlgItem(j+IDC_CHK_ALARM_LINK_OUTPUT_NO1))->SetCheck(false);
			}
		}
	} 
	else
	{
		AddLog(LOG_LEVEL_ERROR,"[CPageSettingAlarm::initShedule_Set] DEC_ClientGetDevConfig Failed! cmd(%d),error(%d)",CMD_DEC_CFG_ALARM_LINK,GetLastError());
	}
}
void CPageSettingAlarm::OnBnClickedButtonAlarmLinkSwitchDisenbale()
{
	AlarmLinkSwitch alarmLS = {0};
	int iRet = DEC_ClientSetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_ALARM_LINK_SWITCH, &alarmLS, sizeof(AlarmLinkSwitch));
	if (iRet != ERR_SUCCESS)
	{
		AddLog(LOG_LEVEL_ERROR,"[DEC_ClientSetDevConfig::CMD_DEC_CFG_ALARM_LINK_SWITCH]Failed!");
	}
}
